/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.ui.containers;

import io.leangen.geantyref.TypeToken;
import java.util.Set;
import java.util.function.Supplier;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.items.ImpactorItemStack;
import net.impactdev.impactor.api.ui.containers.processors.ClickProcessor;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.impactdev.impactor.api.utility.builders.Required;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Icon {
    @NotNull
    public Supplier<ImpactorItemStack> display();

    @NotNull
    public Context context();

    @NotNull
    public Set<ClickProcessor> listeners();

    @Contract(value="_ -> this")
    public Icon listener(ClickProcessor var1);

    public boolean refreshable();

    public static IconBuilder builder() {
        return Impactor.instance().builders().provide(IconBuilder.class);
    }

    public static interface IconBuilder
    extends Builder<Icon> {
        @Required
        public IconBuilder display(Supplier<ImpactorItemStack> var1);

        public IconBuilder listener(ClickProcessor var1);

        default public <T> IconBuilder append(Class<T> key, T value) {
            return this.append(TypeToken.get(key), value);
        }

        public <T> IconBuilder append(TypeToken<T> var1, T var2);

        public IconBuilder constant();

        public IconBuilder from(Icon var1);
    }
}

